ALTER TABLE items
CHANGE regular_price regular_price DOUBLE NOT NULL,
CHANGE extended_price extended_price DOUBLE NOT NULL,
CHANGE total_sales_amount total_sales_amount DOUBLE DEFAULT 0,
CHANGE total_earnings total_earnings DOUBLE DEFAULT 0;

ALTER TABLE item_updates
CHANGE regular_price regular_price DOUBLE NULL,
CHANGE extended_price extended_price DOUBLE NULL;

ALTER TABLE item_discounts
CHANGE regular_price regular_price DOUBLE NOT NULL,
CHANGE extended_price extended_price DOUBLE NULL;

ALTER TABLE users
CHANGE balance balance DOUBLE DEFAULT 0,
CHANGE total_sales_amount total_sales_amount DOUBLE DEFAULT 0,
CHANGE total_referrals_earnings total_referrals_earnings DOUBLE DEFAULT 0;


ALTER TABLE referrals
CHANGE earnings earnings DOUBLE DEFAULT 0;

ALTER TABLE levels
CHANGE min_earnings min_earnings DOUBLE NOT NULL;

ALTER TABLE withdrawals
CHANGE amount amount DOUBLE NOT NULL;

ALTER TABLE sales
CHANGE price price DOUBLE NOT NULL,
CHANGE buyer_fee buyer_fee DOUBLE DEFAULT 0,
CHANGE author_fee author_fee DOUBLE DEFAULT 0,
CHANGE author_earning author_earning DOUBLE DEFAULT 0;


ALTER TABLE transactions
CHANGE amount amount DOUBLE NOT NULL,
CHANGE fees fees DOUBLE DEFAULT 0,
CHANGE total total DOUBLE NOT NULL;

ALTER TABLE transaction_items
CHANGE price price DOUBLE NOT NULL;

ALTER TABLE referral_earnings
CHANGE author_earning author_earning DOUBLE NOT NULL;

ALTER TABLE statements
CHANGE amount amount DOUBLE NOT NULL,
CHANGE buyer_fee buyer_fee DOUBLE DEFAULT 0,
CHANGE author_fee author_fee DOUBLE DEFAULT 0,
CHANGE total total DOUBLE;

ALTER TABLE support_earnings
CHANGE price price DOUBLE NOT NULL,
CHANGE author_fee author_fee DOUBLE DEFAULT 0,
CHANGE author_earning author_earning DOUBLE NOT NULL;

ALTER TABLE plans
CHANGE price price DOUBLE NULL;


ALTER TABLE premium_earnings
CHANGE price price DOUBLE NOT NULL,
CHANGE author_earning author_earning DOUBLE NOT NULL;


ALTER TABLE categories
CHANGE regular_buyer_fee regular_buyer_fee DOUBLE DEFAULT 0,
CHANGE extended_buyer_fee extended_buyer_fee DOUBLE DEFAULT 0;


UPDATE `settings` SET `value` = '{\"maximum_tags\":\"15\",\"minimum_price\":\"1.00\",\"maximum_price\":\"5000.00\",\"buy_now_button\":1,\"free_item_option\":1,\"free_item_total_downloads\":1,\"free_items_require_login\":1,\"external_file_link_option\":1,\"reviews_status\":1,\"comments_status\":1,\"changelogs_status\":1,\"support_status\":1,\"discount_status\":1,\"discount_max_percentage\":\"70\",\"discount_max_days\":\"20\",\"discount_tb\":\"30\",\"discount_tb_pch\":\"30\",\"trending_number\":\"20\",\"best_selling_number\":\"20\",\"max_files\":\"12\",\"max_file_size\":314572800,\"convert_images_webp\":\"1\",\"file_duration\":\"24\",\"adding_require_review\":1,\"updating_require_review\":1}' WHERE `key`="item";

UPDATE `settings` SET `value` = '{\"terms_of_use_link\":\"\\/terms-of-use\",\"author_terms_link\":\"\\/author-terms\",\"referral_terms_link\":\"\\/referral-program-terms\",\"licenses_terms_link\":\"\\/licenses-terms\",\"free_items_policy_link\":\"\\/free-items-policy\",\"gdpr_cookie_policy_link\":\"\\/gdpr-policy\"}' WHERE `key`="links";


